<?php
use yii\helpers\Html;
use app\models\User;
$this->title = 'Чат';
?>
    <div class="bordered center">
    <?php foreach($emojihead as $emh): ?>
		<a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $emh['name'];?>');"><img src="/images/smiles/<?php echo $emh['img'];?>.gif"></a>
		<?php endforeach;?>
	</div>

	<div class="bordered center">

		<textarea class="form-control message-input"></textarea>

			<a class="btn btn-success" onclick="chat(1);"><i class="fa fa-refresh"></i></a>
			<button class="btn btn-success send-message" onclick="sendMessage();">Отправить</button>
			<a class="btn btn-success" onclick="EmojiPanel();"><i class="fa fa-smile-o"></i></a>
	</div>

	<div class="bordered center emojy">

		<?php foreach($emoji as $em): ?>
		<a href="javascript:void(0);" class="label" onclick="Emoji('<?php echo $em['name'];?>');"><img src="/images/smiles/<?php echo $em['img'];?>.gif"></a>
		<?php endforeach;?>

	</div>

	<div class="loading-status"><div class="bordered center loading"><i class="fa fa-spinner fa-spin"></i> Загрузка...</div></div>
	<div class="chat"></div>
	<?php if($pagination->getPage()+1 < $pagination->getPageCount()): ?>

				<div class="bordered center">
					<button class="btn btn-block btn-success" value="<?php echo $pagination->getPageCount();?>" onclick="loadChat()" id="load-chat">Показать ещё</button>
					<input type="hidden" id="page" value="1">

				</div>

			<?php endif;?>
			<input type="hidden" id="reply-input" value="0">
    <div class="content">
        <div class="blocks">
            <a class="btnl mt4" href="/user/admin">Помощь модератора</a>
        </div>
    </div>

<?php
$script = <<< JS

	var btn = $('#load-chat');
	var str = $('#page');

	 function chat(page){

		if(page == 1) str.val(1);
		$('.loading-status').show();
		$('.chat').html();

		$.get('/ajax/chat', {page: page, type: '$type'}, function(data) {



		if(btn.val() > page) btn.show();

		if(page == 1){
		$('.chat').html(data);
		}else{
        $('.chat').append(data);
		}
        $('.loading-status').hide();
		});




	 }


	chat(1);

	function loadChat()
	{


		chat(Number(str.val())+1);
		str.val(Number(str.val())+1);


		if(btn.val() >= Number(str.val())) btn.hide();


	}


	function sendMessage()
	{

		var text = $('.message-input').val();
    var type = '$type';

		if(text == ''){
			swal('Введите сообщение',  '',  'error');

		}else{
			var reply = $('#reply-input').val();

        $.ajax({
  	url: '/ajax/chat-send',
  	method: 'post',
  	dataType: 'json',
  	data: {text: text, type: type, reply: reply},
  	success: function(data){


				if(data.status == 'success') {

					chat(1);
					$('.message-input').val('');
				}

					else

						{

							swal(data.title,  '',  'error');


						}
            }
			});



		}


	}




		function reply(user,id)
	{

		$('.message-input').val(user+', ');
		$('.message-input').focus();

		$('#reply-input').val(id);
	}

	function Emoji(smile)
	{
		var text = $('.message-input').val();

		$('.message-input').val(text+' '+smile);
		$('.message-input').focus();
	}

	function EmojiPanel()
	{

		if ($(".emojy").is(":hidden")) {
            $(".emojy").fadeIn(500);
        } else {
            $(".emojy").fadeOut();
        }


	}

JS;

$this->registerJs($script, $this::POS_END);
